function fade(element, opacity) {
	if (opacity>0) {
		opacity -= .04;
		element.style.opacity = opacity;
		setTimeout(function(){fade(element, opacity)},10);
	} 
}

function show(element, opacity) {
	if (opacity<1) {
		opacity += .04;
		element.style.opacity = opacity;
		setTimeout(function(){show(element, opacity)},10);
	} 
}

function getContainer(title, switchCallback, info_help, enabled, state, body_below, help_bg_class) {
	var info_container_inside = info_help();
	info_container_inside.className += "info_container_inside";
	var info_container = document.createElement("div");
	info_container.className += "info_container-active";
	var main_container = document.createElement("div");
	main_container.className += "main_container";

	var switchElement = document.createElement("label");
	switchElement.className += "switch";
	var inputElement = document.createElement("input");
	inputElement.type = "checkbox";
	inputElement.className = "switchCheckbox " + help_bg_class + "switch";
	inputElement.checked = state;
	console.log("enabled: " + enabled);
	if (enabled) {
		var handleClick = function (arg) {

			switchCallback(arg.checked);
		}

		inputElement.onchange = function() {
			handleClick(this);
			return false
		}

		inputElement.onclick = function() {
			switchCallback(this.checked);
			return false;
		}


	} else {
		inputElement.readonly = true;
		inputElement.onclick = function() {
			return false;
		}
	}



	switchElement.appendChild(inputElement);
	var switchSpan = document.createElement("span");
	if (window.isRtl) {
		switchSpan.className = "rtl";
	}
	switchSpan.className += "slider round";
	if (!enabled)
		switchSpan.className += " disabled";
	switchElement.appendChild(switchSpan)

	var table = document.createElement("table");
	table.className += "container_table";
	if (window.isRtl) {
		table.className += " rtl";
	}
	var tr1 = document.createElement("tr");

	var switchCell = document.createElement("td");
	switchCell.className += "switch_cell";
	switchCell.appendChild(switchElement);
	tr1.appendChild(switchCell);

	var titleCell = document.createElement("td");
	titleCell.className += "title_cell";
	titleCell.innerText = title;
	tr1.appendChild(titleCell);
	if (body_below != undefined) {
		var tr2 = document.createElement("tr");
		var emptyCell = document.createElement("td");
		tr2.appendChild(emptyCell);
		var bodyCell = document.createElement("td");
		bodyCell.className += "body_cell";
		bodyCell.appendChild(body_below());
		tr2.appendChild(bodyCell);
	}
	var expandButtonCell = document.createElement("td");
	expandButtonCell.className += "expand_button_cell";

	var expandButton = document.createElement("div");
	expandButton.className += "expand_button";
	if (window.isRtl) {
		expandButton.className += " flipImage"
	}
	(function() {
	expandButton.onclick = function () {
		t = document.getElementById("helpDiv");
		if (t != undefined) {
				t.parent.removeChild(t);
		}
		var helpDiv = document.createElement("div");
		helpDiv.id = "helpDiv";
		helpDiv.style.opacity = 0;
		if (help_bg_class != undefined) {
			var categoryImageDiv = document.createElement("div");
			categoryImageDiv.className = help_bg_class + " help_bg";
			helpDiv.appendChild(categoryImageDiv);
		}
		var helpDivContentTitle = document.createElement("p");
		helpDivContentTitle.innerText = title;
		helpDivContentTitle.className = "helpDivContentTitle";
		var helpDivContent = info_help();
		helpDivContent.className = "helpDivContent";
		document.getElementById("mainDiv").style.pointerEvents = "none";
		backButton = document.createElement("input");
		backButton.type = "button";
		backButton.value = " < "
		backButton.onclick = function () {
			setTimeout(function(){show(document.getElementById("mainDiv"),0)},1);
			setTimeout(function(){fade(helpDiv,1)},1);
			setTimeout(function(){
				document.body.removeChild(helpDiv);
			},400)
			helpDiv.style.pointerEvents = "none";
			document.getElementById("mainDiv").style.pointerEvents = "initial";

		}
		helpDiv.appendChild(backButton);
		helpDiv.appendChild(helpDivContent);
		helpDiv.appendChild(helpDivContentTitle);
		document.body.appendChild(helpDiv);
		setTimeout(function(){fade(document.getElementById("mainDiv"),1)},1);
		setTimeout(function(){show(helpDiv,0)},1);
	}
	})();
	expandButtonCell.appendChild(expandButton);

	tr1.appendChild(expandButtonCell);
	table.appendChild(tr1);
	if (body_below != undefined) 
		table.appendChild(tr2);
	main_container.appendChild(table);
	return main_container

};


var namesArray = [
	"WebAV"
	,
	"WebTracking"
	,
	"CompAccounts"
	,
	"SafeMoney"
	,
	"DuplicatePasswords"
	,
	"PasswordStrength"
	,
	"URLAdvisor"
	,
	"onScrKbd"
]

var containerNames = {};
containerNames["WebAV"] = {
	title: "kaspersky_security_label_web_anti_virus",
	popover: "kaspersky_security_popover_web_anti_virus",
};
containerNames["WebTracking"] = {
	title: "kaspersky_security_label_website_tracking",
	popover: "kaspersky_security_popover_website_tracking",
};
containerNames["CompAccounts"] = {
	title: "kaspersky_security_label_compromised_accounts",
	popover: "kaspersky_security_popover_compromised_accounts",
};
containerNames["SafeMoney"] = {
	title: "kaspersky_security_label_safe_money",
	popover: "kaspersky_security_popover_safe_money",
};
containerNames["DuplicatePasswords"] = {
	title: "kaspersky_security_label_duplicate_password",
	popover: "kaspersky_security_popover_duplicate_password",
};
containerNames["PasswordStrength"] = {
	title: "kaspersky_security_label_password_strength",
	popover: "kaspersky_security_popover_password_strength",
};
containerNames["URLAdvisor"] = {
	title: "kaspersky_security_label_url_advisor",
	popover: "kaspersky_security_popover_url_advisor",
};
containerNames["onScrKbd"] = {
	title: "kaspersky_security_label_onscreen_keyboard",
	popover: "kaspersky_security_popover_onscreen_keyboard",
	button: "kaspersky_security_button_open_keyboard",
};

function getWrappedContainer(containerName, edit_enabled, state){
	if (containerName in containerNames) {
		return getContainer(
			Localization.getString(containerNames[containerName].title),
			function(state) {
				if (state != undefined) {
					KL.callGlobalObject("setSwitchState", [containerName, state],
						function(result) {
							if (result != undefined) {
								console.log(containerName + " result: " + result);
								document.getElementsByClassName(containerName + "switch")[0].checked = result;
							}
						},
					    true
					);
				}
			},
			function() {
				var testP = document.createElement("p");
				testP.innerText = Localization.getString(containerNames[containerName].popover);
				return testP;
			},
			edit_enabled,
			state,
			undefined,
			containerName
		)
	} else {
		console.error("NO SUCH CONTAINER");
	}
}

function insertNoProtectionBanner(string, displayButton, warningSignColor) {
	var noProtectionDiv = document.createElement("div");
	if(window.isRtl)
		noProtectionDiv.setAttribute("dir", "rtl")
	noProtectionDiv.className = "main_container noProtectionDiv";
	if (!displayButton)
		noProtectionDiv.className += " thin";
	var exclamationMark = document.createElement("div");
	exclamationMark.className = "protectionDisabledExclamationMark " + warningSignColor + "SignBG";
	noProtectionDiv.appendChild(exclamationMark);
	var noProtectionTitle = document.createElement("div");
	noProtectionTitle.innerText = string;
	noProtectionTitle.className = "protectionDisabledTitle";
	noProtectionDiv.appendChild(noProtectionTitle);
	if (displayButton) {
		var noProtectionButton = document.createElement("button");
		noProtectionButton.type = "button";
		noProtectionButton.innerText = Localization.getString("kaspersky_security_protection_disabled_description");
		noProtectionButton.className = "protectionDisabledDescription";
		noProtectionButton.onclick = function () {
			KL.callGlobalObject("openProduct");
			KL.hidePopover();
		}
		noProtectionDiv.appendChild(noProtectionButton);
	}

	document.getElementById("mainDiv").appendChild(noProtectionDiv);
}

function protectionDisabledNoBlConnection() {
	protectionDisabled("kaspersky_security_no_bl_connection_title", true);
}

function protectionDisabledNoProtection(result) {
	setupInterface(result, "kaspersky_security_protection_disabled_title", true);
}

function protectionDisabledNoLicense(result) {
	setupInterface(result, "kaspersky_security_no_license_title", true);
}

function protectionDisabledLimitedLicense(result) {
	setupInterface(result, "kaspersky_security_limited_license_title", true, "yellow");
}

function protectionGracePeriod(result) {
	setupInterface(result, "kaspersky_security_no_license_title", true, "yellow");
}

function protectionUpdateFailed(result) {
	setupInterface(result, "kaspersky_security_no_license_title", true, "yellow");
}

function protectionDisabled(string, displayButton, warningSignColor) {
	print_call_stack()
	if (warningSignColor == undefined) {
		warningSignColor = "red";
	}
 	if (displayButton == undefined) {
		displayButton = true;
	} 

	var mainDiv = document.getElementById("mainDiv");
	mainDiv.innerHTML = null;
	insertNoProtectionBanner(Localization.getString(string), displayButton, warningSignColor);
	var states = [1,1,0,1,0,0,1,1];
	for (var i = 0; i < states.length; i++) {
		if (states[i] == 1 || states[i] == 2 || states[i] == 3) {
			mainDiv.appendChild(getWrappedContainer(namesArray[i], false, false));
		}
	}
}

function drawForVersion18(){
	var mainDiv = document.getElementById("mainDiv");
	mainDiv.innerHTML = null;
	var openKbdButtonImage = document.createElement("div");
	openKbdButtonImage.className += "open_kbd_image";

	var openKbdButtonText = document.createElement("div");
	openKbdButtonText.className += "open_kbd_text";
	openKbdButtonText.innerText = Localization.getString("toolbar_button_hint");

	var openKbdButton = document.createElement("div");
	openKbdButton.className += "button_container";
	openKbdButton.appendChild(openKbdButtonImage);
	openKbdButton.appendChild(openKbdButtonText);
	openKbdButton.onclick = function() {
	    KL.callGlobalObject("showKeyboard");
	    KL.hidePopover();
	};

	var openKavAppButton = document.createElement("button");
	openKavAppButton.className += "open_pref_button";
	openKavAppButton.innerText = Localization.getString("open_extensions_preferences_button");
	openKavAppButton.onclick = function() {
	    KL.callGlobalObject("openPreferencesInProduct");
	    KL.hidePopover();
	};
	var footer = document.createElement("div");
	footer.className += "footer";

	mainDiv.appendChild(openKbdButton);
	mainDiv.appendChild(openKavAppButton);
	mainDiv.appendChild(footer);
}

function getSwitchStatesAndDraw() {
	KL.callGlobalObject("getSwitchStates", {},
		function(result) {
			console.log("result getSwitchStatesAndDraw:" + result);
			if (result != undefined) {
				setupInterface(result);
			} else {
				protectionDisabledNoBlConnection();
			}
			console.log("result switch states");
			console.log(result);
		},
	    true
	);
}

function drawForVersion(version) {
	if (version == 19) {
		if (Localization.getString("rtl") == "yes") {
			window.isRtl = true;
		} else {
			window.isRtl = false;
		}
		KL.callGlobalObject("getStatus", {},
			function(result){
				console.log("result getStatus: " + result);
				if (result == undefined)
					protectionDisabledNoBlConnection();
				if (result[0] == "OK") {
					setupInterface(result[1]);
				} else if (result[0] == "blConn"){
					protectionDisabledNoBlConnection();
				} else if (result[0] == "protection") {
					protectionDisabledNoProtection(result[1]);
				} else if (result[0] == "licenseBad"){
					protectionDisabledNoLicense(result[1]);
				} else if (result[0] == "licenseLimited"){
					protectionDisabledLimitedLicense(result[1]);
                } else if (result[0] == "gracePeriod"){
                    protectionGracePeriod(result[1]);
				} else if (result[0] == "licenseUpdateFailed") {
					protectionUpdateFailed(result[1]);
				} else {
					console.error("UNKNOWN RESULT IN drawForVersion");
					KL.logError("UNKNOWN RESULT IN drawForVersion");
					protectionDisabledNoBlConnection();
				}
			},
			true
		)
	} else {
		console.error("GOT WRONG VERSION: " + version);
	}
}

function print_call_stack() {
	var stack = new Error().stack;
	console.log("PRINTING CALL STACK");
	console.log( stack );
  }
  function setupInterface(states, string, displayButton, warningSignColor) {
	  KL.callGlobalObject("getDNTStatistics",[],
		  function(result) {
			  if (result == false) {
				  protectionDisabledNoBlConnection()
				  return
			  }
			  if (result != undefined) {
				  var mainDiv = document.getElementById("mainDiv");
				  mainDiv.innerHTML = null;
				  if (string != undefined)
					  insertNoProtectionBanner(Localization.getString(string), displayButton, warningSignColor);
				  for (var i = 0; i < states.length - 1; i++) {
					  if (i == 1) 
					  {	
						  (function(){
							  var containerName = namesArray[1];
							  mainDiv.appendChild(
								  getContainer(
									  Localization.getString(containerNames[containerName].title),
									  function(state) {
										  if (state != undefined) {
											  KL.callGlobalObject("setSwitchState", [containerName, state],
												  function(result) {
													  if (result != undefined) {
														  console.log(containerName + " result: " + result);
														  document.getElementsByClassName(containerName + "switch")[0].checked = result;
													  }
												  },
												  true
											  );
										  }
									  },
									  function() {
										  var testP = document.createElement("p");
										  testP.innerText = Localization.getString(containerNames[containerName].popover);
										  return testP;
									  },
									  states[1] != 4,
									  states[1] == 2 || states[1] == 3,
									  function() {
										  var isRTL = Localization.getString("rtl") === "yes";
										  var container = document.createElement("div");
										  if (isRTL) {
										    container.setAttribute("dir", "rtl");
										  }
										  var totalAttemptsStr = Localization.getString("kaspersky_security_sub_label_tracking_attempts") + result[0];
										  var totalNotBlockedStr = Localization.getString("kaspersky_security_sub_label_tracking_not_blocked") + result[1];
										  var spanAttempts = document.createElement("span");
										  spanAttempts.className = "sublabel";
										  spanAttempts.innerText = totalAttemptsStr;
										  container.appendChild(spanAttempts);
										  var spanNotBlockedStr = document.createElement("span");
										  spanNotBlockedStr.className = "sublabel";
										  spanNotBlockedStr.innerText = totalNotBlockedStr;
										  container.appendChild(spanNotBlockedStr);
										  var divFullReport = document.createElement("div");
										  divFullReport.className = "fullReportLabel";
										  divFullReport.innerText = Localization.getString("kaspersky_security_sub_label_full_report");
										  divFullReport.onclick = function() {
											  openDntReport();
										  }
										  container.appendChild(divFullReport);
										  var button = document.createElement("div");
										  button.className = "fullReportArrow";
										  if (isRTL) {
											  button.className += " flipImage"
										  }
										  button.onclick = function() {
											  openDntReport();
										  }
										  container.appendChild(button);
										  return container;
									  },
									  containerName
								  )
							  )
						  })();
					  } else {
						  if (states[i] >= 1) {
							  mainDiv.appendChild(getWrappedContainer(namesArray[i], states[i] != 4, (states[i] == 2 || states[i] == 3) ? true : false));
						  }
					  }
				  }
				  if (states[7] > 0) { 
					  (function(){
						  var containerName = namesArray[7];
						  mainDiv.appendChild(
							  getContainer(
								  Localization.getString(containerNames[containerName].title),
								  function(state) {
									  if (state != undefined) {
										  KL.callGlobalObject("setSwitchState", [containerName, state],
											  function(result) {
												  if (result != undefined) {
													  console.log(containerName + " result: " + result);
													  document.getElementsByClassName(containerName + "switch")[0].checked = result;
												  }
											  },
											  true
										  );
									  }
								  },
								  function() {
									  var testP = document.createElement("p");
									  testP.innerText = Localization.getString(containerNames[containerName].popover);
									  return testP;
								  },
								  states[7] != 4,
								  states[7] >= 2,
								  function() {
									  var button = document.createElement("button");
									  button.innerText = Localization.getString(containerNames[containerName].button);
									  button.onclick = function() {
										  KL.callGlobalObject("showKeyboard");
										  KL.hidePopover();
									  }
									  return button;
								  },
								  containerName
							  )
						  )
					  })();
				  }
			  }
		  },
		  true
	  )
  }
  function openDntReport() {
	  KL.callGlobalObject("openIDntReportInProduct");
	  KL.hidePopover();
  }
  (function() {
	  KL.launchScriptOnPageLoad(function() {
		  var mainContentDiv = document.createElement("div");
		  mainContentDiv.className = "MainContentDiv";
		  mainContentDiv.id = "mainDiv";
		  document.body.appendChild(mainContentDiv);  
		  KL.callGlobalObject("getVersion",{},
						  function(result) {
							  console.log("got version: " + result);
							  if (result == undefined) 
								  return;
							  if (result == 18) {
								  drawForVersion18();
							  } else {
								  drawForVersion(result);
							  }
						  },
						  true
					  );
	  });
  })();
